-----------------------------------------------------------------------------------
/*
Vjebe se rade na bazi AdventureWorksOBP. 
*/
USE AdventureWorksOBP
GO
-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
VARIJABLE
Deklarirajte varijable @Ime i @Prezime i dodijelite im neke vrijednosti. 
Ispiite dodijeljene vrijednosti.
*/
DECLARE @Ime nvarchar(50)
DECLARE @Prezime nvarchar(50)

SET @Ime = 'Miro'
SET @Prezime = 'Miri'

PRINT @Ime
PRINT @Prezime
PRINT 'Korisnik: ' + @Ime + ' ' + @Prezime
GO
-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
VARIJABLE
Deklarirajte varijable @Ime i @Prezime i dodijelite im vrijednosti iz tablice Kupac za IDKupac jednak 8812. 
Ispiite dodijeljene vrijednosti.
*/
DECLARE @Ime nvarchar(50)
DECLARE @Prezime nvarchar(50)

SELECT @Ime = Ime, @Prezime = Prezime FROM Kupac WHERE IDKupac = 8812

PRINT 'Korisnik: ' + @Ime + ' ' + @Prezime
GO
-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
VARIJABLE
Deklarirajte varijable @Ime i @Prezime i dodijelite im vrijednosti iz tablice Kupac tako da odaberete sve retke iz tablice. 
Ispiite dodijeljene vrijednosti.
*/
DECLARE @Ime nvarchar(50)
DECLARE @Prezime nvarchar(50)

SELECT @Ime = Ime, @Prezime = Prezime FROM Kupac

PRINT 'Korisnik: ' + @Ime + ' ' + @Prezime
GO
-----------------------------------------------------------------------------------
SET NOCOUNT ON
-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
IF-ELSE IF-ELSE i SCOPE_IDENTITY()
Provjerite broj zapisa u tablici Kupac. 
Ako ih ima vie ili jednako 20000, ispiite Postoji vie od 20000 kupaca :). 
Ako ih ima manje, ispiite Jo nismo dostigli 20000 kupaca :(
*/
DECLARE @Broj int
SELECT @Broj = COUNT(*) FROM dbo.Kupac
IF @Broj >= 20000
	PRINT 'Postoji vie od 20000 kupaca :)'
ELSE
	PRINT 'Jo nismo dostigli 20000 kupaca :('
GO
-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
IF-ELSE IF-ELSE i SCOPE_IDENTITY()
Umetnite zapis u tablicu Drzava, generiranu IDENTITY vrijednost dodijelite nekoj varijabli pa je ispiite.
*/
DECLARE @NoviID int
INSERT INTO Drzava VALUES ('Gruzija')
SET @NoviID = SCOPE_IDENTITY()
PRINT @NoviID
GO
-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
IF-ELSE IF-ELSE i SCOPE_IDENTITY()
Umetnite zapis u tablicu Drzava i u varijablu spremite generiranu IDENTITY vrijednost. 
Iskoristite tu vrijednost da biste za tu dravu umetnuli dva grada.
*/
DECLARE @IDDrzavaNovi int
INSERT INTO Drzava VALUES ('Kina')
select SCOPE_IDENTITY()
SET @IDDrzavaNovi = SCOPE_IDENTITY()

INSERT INTO Grad VALUES ('angaj', @IDDrzavaNovi)
INSERT INTO Grad VALUES ('Peking', @IDDrzavaNovi)
GO

-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Izrada log tablice.
CREATE TABLE Zapisnik
(
	IDZapisnik int IDENTITY(1,1) PRIMARY KEY,
	Poruka nvarchar(max),
	Vrijeme datetime DEFAULT getdate()
)
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
Napravite okida kojim ete svako umetanje retka u tablicu Grad zapisati u tablicu Zapisnik. 
Umetnite redak.
*/
CREATE TRIGGER Okidac1 ON Grad AFTER INSERT
AS
INSERT INTO Zapisnik (Poruka) VALUES ('Umetnut redak u Grad!')
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 1', 1)

SELECT * FROM Zapisnik
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
Promijenite okida tako da zapie ID i naziv umetnutog grada u Zapisnik. 
Umetnite redak.
*/
ALTER TRIGGER Okidac1 ON Grad AFTER INSERT
AS
DECLARE @ID int
DECLARE @Naziv nvarchar(50)
SELECT @ID = IDGrad, @Naziv = Naziv FROM inserted

INSERT INTO Zapisnik (Poruka) VALUES ('Umetnut redak u Grad. IDGrad: ' + CAST(@ID as nvarchar(50)) + ', Naziv: ' + @Naziv)
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 2', 1)

SELECT * FROM Zapisnik
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
Promijenite okida tako da se vee uz sve dogaaje i u Zapisnik zapisuje broj redaka u inserted i deleted tablicama. 
Umetnite dva nova grada, promijenite im drave i na kraju ih obriite.
*/
ALTER TRIGGER Okidac1 ON Grad AFTER INSERT, UPDATE, DELETE
AS
DECLARE @i int
DECLARE @d int
SELECT @i = COUNT(*) FROM inserted
SELECT @d = COUNT(*) FROM deleted

INSERT INTO Zapisnik (Poruka) VALUES ('inserted: ' + CAST(@i as nvarchar(20)) + ', deleted: ' + CAST(@d as nvarchar(20)))
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 3', 1)
INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 4', 1)
SELECT * FROM Zapisnik

UPDATE Grad SET DrzavaID = 2 WHERE Naziv LIKE 'Grad%'
SELECT * FROM Zapisnik

DELETE FROM Grad WHERE Naziv LIKE 'Grad%'
SELECT * FROM Zapisnik
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
Promijenite okida tako da upisuje staru i novu vrijednost promijenjenog naziva grada u Zapisnik. 
Promijenite naziv jednom gradu.
*/
ALTER TRIGGER Okidac1 ON Grad AFTER UPDATE
AS
DECLARE @old nvarchar(50)
DECLARE @new nvarchar(50)
SELECT @old = Naziv FROM deleted
SELECT @new = Naziv FROM inserted

INSERT INTO Zapisnik (Poruka) VALUES ('Stara: ' + @old + ', nova: ' + @new)
GO

UPDATE Grad SET Naziv = 'Daruvar' WHERE IDGrad = 1
SELECT * FROM Zapisnik
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
Onemoguite okida iz prethodnih primjera i promijenite neki redak u tablici. 
Ponovno ga omoguite. 
Napravite opet promjenu. 
Uklonite okida.
*/
DISABLE TRIGGER Okidac1 ON Grad
GO

UPDATE Grad SET Naziv = 'Bjelovar' WHERE IDGrad = 1
SELECT * FROM Zapisnik
GO

ENABLE TRIGGER Okidac1 ON Grad
GO

UPDATE Grad SET Naziv = 'Vukovar' WHERE IDGrad = 1
SELECT * FROM Zapisnik
GO

DROP TRIGGER Okidac1
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
Dodajte novi okida na tablicu Grad i veite ga uz sva tri dogaaja. 
U okidau saznajte koji dogaaj ga je pozvao i tu informaciju upiite u Zapisnik. 
Napravite umetanje, izmjenu i brisanje nekog retka. 
Uklonite okida. 
*/
CREATE TRIGGER Okidac2 ON Grad AFTER INSERT, UPDATE, DELETE
AS
IF EXISTS(SELECT * FROM inserted) AND NOT EXISTS(SELECT * FROM deleted) BEGIN
	-- INSERT.	
	INSERT INTO Zapisnik (Poruka) VALUES ('Desio se INSERT.')
END
ELSE IF NOT EXISTS(SELECT * FROM inserted) AND EXISTS(SELECT * FROM deleted) BEGIN
	-- DELETE.
	INSERT INTO Zapisnik (Poruka) VALUES ('Desio se DELETE.')
END
ELSE IF EXISTS(SELECT * FROM inserted) AND EXISTS(SELECT * FROM deleted) BEGIN
	-- UPDATE.
	INSERT INTO Zapisnik (Poruka) VALUES ('Desio se UPDATE.')
END
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 5', 1)
SELECT * FROM Zapisnik

UPDATE Grad SET Naziv = 'Ilok' WHERE IDGrad = 1
SELECT * FROM Zapisnik

DELETE FROM Grad WHERE IDGrad = 76
SELECT * FROM Zapisnik
GO

DROP TRIGGER Okidac2
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 7.
/*
Dodajte novi okida i veite ga uz UPDATE dogaaj na tablici Grad. 
Neka okida zapie u Zapisnik da se desio dogaaj samo ako je promijenjen stupac DrzavaID. 
Uklonite okida.
*/
CREATE TRIGGER Okidac3 ON Grad AFTER UPDATE
AS
IF UPDATE(DrzavaID) BEGIN
	INSERT INTO Zapisnik (Poruka) VALUES ('Promijenjen je stupac DrzavaID.')
END
GO

UPDATE Grad SET Naziv = 'ibenik' WHERE IDGrad = 1
SELECT * FROM Zapisnik

UPDATE Grad SET DrzavaID = 3 WHERE IDGrad = 1
SELECT * FROM Zapisnik
GO

DROP TRIGGER Okidac3
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 8.
/*
Dodajte 4 nova okidaa koji u zapisnik ispisuju "Pozdrav iz broja n" nakon umetanja retka. 
Umetnite redak. 
Posloite redoslijed okidaa tako da bude 4, 2, 3, 1. 
Umetnite redak. 
Vratite originalni redoslijed. 
Umetnite redak. 
Uklonite okidae.
*/
CREATE TRIGGER Okidac1 ON Grad AFTER INSERT AS
INSERT INTO Zapisnik (Poruka) VALUES ('Pozdrav iz broja 1')
GO

CREATE TRIGGER Okidac2 ON Grad AFTER INSERT AS
INSERT INTO Zapisnik (Poruka) VALUES ('Pozdrav iz broja 2')
GO

CREATE TRIGGER Okidac3 ON Grad AFTER INSERT AS
INSERT INTO Zapisnik (Poruka) VALUES ('Pozdrav iz broja 3')
GO

CREATE TRIGGER Okidac4 ON Grad AFTER INSERT AS
INSERT INTO Zapisnik (Poruka) VALUES ('Pozdrav iz broja 4')
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 6', 1)
SELECT * FROM Zapisnik
GO

EXEC sp_settriggerorder 'Okidac4', 'FIRST', 'INSERT'
EXEC sp_settriggerorder 'Okidac1', 'LAST', 'INSERT'
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 7', 1)
SELECT * FROM Zapisnik
GO

EXEC sp_settriggerorder 'Okidac4', 'NONE', 'INSERT'
EXEC sp_settriggerorder 'Okidac1', 'NONE', 'INSERT'
GO

INSERT INTO Grad (Naziv, DrzavaID) VALUES ('Grad 8', 1)
SELECT * FROM Zapisnik
GO

DROP TRIGGER Okidac1
DROP TRIGGER Okidac2
DROP TRIGGER Okidac3
DROP TRIGGER Okidac4
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 9.
/*
Napravite tablice Tbl1 i Tbl2 s proizvoljnim stupcima. 
Na Tbl1 napravite okida vezan uz INSERT koji umee retke u Tbl2 i u Zapisnik. 
Na Tbl2 napravite okida vezan uz INSERT koji umee retke u Tbl1 i u Zapisnik. 
Umetnite jedan redak u Tbl1. 
to pie u svakoj od tablica?
*/
CREATE TABLE Tbl1
(
	Stupac1 int PRIMARY KEY IDENTITY,
	Stupac2 nvarchar(50)
)
CREATE TABLE Tbl2
(
	Stupac1 int PRIMARY KEY IDENTITY,
	Stupac2 nvarchar(50)
)
GO

CREATE TRIGGER Okidac1 ON Tbl1 AFTER INSERT 
AS
INSERT INTO Zapisnik (Poruka) VALUES ('Okida 1 na tablici 1')
INSERT INTO Tbl2 VALUES ('Upis u drugu tablicu')
GO

CREATE TRIGGER Okidac2 ON Tbl2 AFTER INSERT 
AS
INSERT INTO Zapisnik (Poruka) VALUES ('Okida 2 na tablici 2')
INSERT INTO Tbl1 VALUES ('Upis u prvu tablicu')
GO

INSERT INTO Tbl1 VALUES ('Upis u prvu tablicu')
SELECT * FROM Zapisnik
GO

SELECT * FROM Tbl1
SELECT * FROM Tbl2
SELECT * FROM Zapisnik
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
